#ifndef INTERFACE_H_INCLUDED
#define INTERFACE_H_INCLUDED

#include <stdlib.h>
#include <string.h>
#include <SDL/SDL.h>
#include <SDL/SDL_image.h>
#include <SDL/SDL_ttf.h>


#define SAISIE_MAX 255
#define TITRE "Kaaptur - Editeur de Map"

#define BITSPERPIXEL 32
#define POLICE_TEXTE "papyrus.ttf"
#define POLICE_TAILLE_NORMALE 18
#if SDL_BYTEORDER == SDL_BIG_ENDIAN
    #define RMASK  0xff000000
    #define GMASK  0x00ff0000
    #define BMASK  0x0000ff00
    #define AMASK  0x000000ff
#else
    #define RMASK  0x000000ff
    #define GMASK  0x0000ff00
    #define BMASK  0x00ff0000
    #define AMASK  0xff000000
#endif

#define TILE_TAILLE 32
#define SCROLL_BORDURE 64
#define RESSOURCES_DIR "ressources/"


long ELEMENT_SWITCH_TYPE; // Temporaire, Developpement

// Enumeration des Types d'lements de GUI
enum gui_type {
IMAGE,  // Simple image
TEXTE,  // Simple texte
BOUTON, // Bouton avec uen action lors d'un clic
SWITCH, // Bouton ON/OFF
SAISIE, // Entre utilisateur
MAP     // Minimap, Avec deplacement de l'ecran
};

// Action des venements du GUI
enum gui_flag {
AUCUN,              // Ne dclenche rien (mais peut modifier une donne de manire transparente)
ECRAN,              // Ne dclenche rien (mais peut modifier une donne de manire transparente)
TILEACTUELLE,       // Image de la tile actuelle
MINIMAP,            // Image de la minimap
MINIMAP_CURSEUR,    // Curseur de la minimap
GENERER,
SAUVEGARDER,        // Action de sauvegarder
SWITCH_TYPE,        // Bouton du Menu droulant poru le Type de terrain
TILE_TYPE_SOL,      // Bouton qui dfinit le type de la tile actuelle  SOL
TILE_TYPE_OBSTACLE, // Bouton qui dfinit le type de la tile actuelle  OBSTACLE
TILE_TYPE_CAMP,     // Bouton qui dfinit le type de la tile actuelle  CAMP
TILE_TYPE_MORTEL,   // Bouton qui dfinit le type de la tile actuelle  MORTEL
TILE_PRECEDENT,     // Bouton qui rend la tile prcedente active
TILE_SUIVANT,       // Bouton qui rend la tile suivante active
TILE_COUT,          // Saisie du cout en pts de mouvement de la tile actuelle
MESSAGES,            // Fenetre du chat
FPS                 // Frames par secondes
};

enum gui_groupe {
FENETRE,    // Pas de groupe particulier
BARRE,      // Barre Latrale
MENU_TYPE,  // Menu Principal
POPUP_CHAT, // Fenetre du Chat / Messages
};

// Etat des elements
enum gui_etat {
INACTIF,    // Element inactif
SURVOL,     // Element survol (Highlihted)
ACTIF       // Element actif (cliqu, actionn,...)
};

// Flag d'indication de la manire de librer les donnes d'un element
enum gui_free {
FREE_RIEN=0,    // Ne rien liberer (car pointeurs obselete)
FREE_IMAGE=1,   // Librer la surface de l'image
FREE_VALEUR=2   // Librer la chaine de caractre de la valeur
};

// Structure d'un lement du GUI - Graphical User Interface
typedef struct s_gui_element {
    /// Apparence de l'element
    enum gui_type type; // Type de l'element (BOUTON, IMAGE, SWITCH, etc...)
    SDL_Surface *image; // Surface de l'image de l'element
    char *valeur; // Texte ou Valeur de l'element
    SDL_Rect position; // Position de l'element
    SDL_Rect crop; // Coordonnes de rognage
    enum gui_etat etat; //0 -> Inactif, 1-> MOUSE_OVER, 2 - ACTIF
    long visible; // Boolen qui indique sa visibilit

    ///Fonction de l'element
    enum gui_flag flag; // Action de l'element
    enum gui_groupe groupe; // Groupe d'elements auquel appartient l'element
    /// Traitement de l'element
    enum gui_free free; // Determine comment l'element doit tre supprim
//  long actualiser; // Determine si l'element a t modifi, et s'il doit tre re-blitt
} t_gui_element;

// Structure Unique de l'interface
typedef struct s_interface {
    /// Donnes d'affichage SDL
    SDL_Surface* fenetre; // Surface contenant la fenetre
    TTF_Font* font; // Police de Caractre de l'SDL_Rect ecran_prop; interface

    /// Donnes du GUI
    long gui_taille; // Nombre d'elements du GUI
    t_gui_element** gui; // Liste des elements du GUI
    t_gui_element* gui_actif; // Pointeur sur l'element du GUI Actif/Courant

    /// Donnes de la saisie utilisatuer
    long continuer; // Indique si la boucle principale doit tre poursuivie
    SDL_Rect pointeur;// Position de la souris
    SDL_Rect curseur;// Position du curseur dans la map
    long clic; // Boolen de l'tat du clic (gauche)
    SDLKey touche; // La touche actuellement enfonce
    long mousefocus; // Boolen qui indique si la souris est dans la fenetre
    long appfocus;// Utilis pour le clic, et le dessin de la map, et le focus de la fenetre

    /// Donnes de l'diteur de maps
    char accent; //Retient si un accent (circonflxe, trma ou tilde) est entr
    long tile;// Contient la tile actuelle
} t_interface;

#include "map.h"

// Fonctions d'initialisation / libration
void initialiser_affichage(SDL_Surface** fenetre,long largeur,long hauteur); // Initialise la SDL
void initialiser_interface(t_interface* interface,t_map *map); // Initialise l'interface et les elements du GUI
void liberer_interface(t_interface* interface); // Supprime les donnes de l'interface
void liberer_affichage(SDL_Surface* fenetre); // Libre la fenetre, et quitte les librairies initialises

// Fonctions d'affichage / Rafraichissement
void afficher_interface(t_interface* interface,t_map* map); // Affiche l'interface
void afficher_message(t_interface* interface, char *txt, long rouge, long vert, long bleu); // Affiche un message dans la fenetre de chat

// Fonctions de gestion des venements GUI
long obtenir_element(t_interface *interface,enum gui_flag flag); // Rcupre le dernier element portant le flag prcis
void afficher_groupe(t_interface *interface, enum gui_groupe groupe, long visible); // Affiche / Masque un groupe d'elements en fonction de visible
void actualiser_gui(long element,t_interface* interface,t_map* map); // Actualise les elements et les donnes avant affichage
void effectuer_gui(enum gui_flag flag,t_interface* interface,t_map* map); // Effectuer l'action d'un flag
void scroller_ecran(t_interface* interface,t_map* map); // Scrolle l'ecran en fonction du curseur / Touche enfonce
SDL_Rect obtenir_curseur_minimap(t_interface* interface,t_map *map);
long obtenir_fps(long incrementer); // Obtient le nombre d'Images par Secondes (et incrmente le nombre de rafraichissement)

// Fonctions Diverses
Uint32 GetPixel(SDL_Surface* surface, long x, long y);  // Renvoie le pixel d'une surface
#endif // INTERFACE_H_INCLUDED
